CREATE OR REPLACE FUNCTION createView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT * FROM information_schema."views" 
                    WHERE upper(table_name)= 'V_RC_CLI_CONV_PBM') THEN 
						 
		CREATE VIEW V_RC_CLI_CONV_PBM
			AS SELECT 
				rc_cli.cd_emp,	
				rc_cli.cd_cli,
				rc_cli.rz_cli,
				rc_cli.nm_fant,
				rc_cli_conv.cd_conv,
				rc_cli_conv.ds_conv,
				rc_cli.rot_conv_ext
			   FROM rc_cli
				 LEFT JOIN rc_cli_conv ON 
						rc_cli.cd_conv = rc_cli_conv.cd_conv AND 
						rc_cli.cd_emp = rc_cli_conv.cd_emp
				 WHERE rc_cli.sts_cli = 0::numeric and rot_conv_ext > 0;

        RAISE NOTICE 'Operacao realizada com sucesso.';                                   
    ELSE 
		DROP VIEW V_RC_CLI_CONV_PBM;
		CREATE VIEW V_RC_CLI_CONV_PBM
			AS SELECT 
				rc_cli.cd_emp,	
				rc_cli.cd_cli,
				rc_cli.rz_cli,
				rc_cli.nm_fant,
				rc_cli_conv.cd_conv,
				rc_cli_conv.ds_conv,
				rc_cli.rot_conv_ext
			   FROM rc_cli
				 LEFT JOIN rc_cli_conv ON 
						rc_cli.cd_conv = rc_cli_conv.cd_conv AND 
						rc_cli.cd_emp = rc_cli_conv.cd_emp
				 WHERE rc_cli.sts_cli = 0::numeric and rot_conv_ext > 0;	 
    END IF;

	RAISE NOTICE 'Operacao realizada com sucesso.';   	
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION createView() OWNER TO postgres; 
SELECT createView(); 
DROP FUNCTION createView();